<?php

     use Illuminate\Database\Migrations\Migration;
     use Illuminate\Database\Schema\Blueprint;
     use Illuminate\Support\Facades\Schema;

     class CreateCourseCategoriesTable extends Migration
     {
         public function up()
         {
             Schema::create('course_categories', function (Blueprint $table) {
                 $table->id('Category_id');
                 $table->string('Name');
                 $table->text('Description')->nullable();
                 $table->unsignedBigInteger('Parent_id')->nullable()->comment('For sub-categories');
                 $table->longText('Metadata')->nullable()->comment('Dynamic metadata (e.g., tags, filters)');
                 $table->timestamp('Created_at')->useCurrent();
                 $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

                 $table->foreign('Parent_id')->references('Category_id')->on('course_categories')->onDelete('set null')->onUpdate('cascade');
             });
         }

         public function down()
         {
             Schema::dropIfExists('course_categories');
         }
     }
